import tkinter
import random


# funkcie z povodneho riesenia
def prazdna():
    siet = []
    for i in range(n):
        siet.append([0] * n)
    return siet


def nahodna():
    siet = []
    for i in range(n):
        siet.append([random.randrange(2) for i in range(n)])
    return siet


def pocet_susedov(r, s):
    pocet = 0
    for i in r - 1, r, r + 1:
        for j in s - 1, s, s + 1:
            if 0 <= i < n and 0 <= j < n:
                pocet += generacia[i][j]
    return pocet - generacia[r][s]


def dalsia_generacia():
    global generacia
    global ktora
    nova = []
    for i in range(n):
        nova.append([0] * n)

    for i in range(n):
        for j in range(n):
            p = pocet_susedov(i, j)
            if generacia[i][j] == 0:
                if p == 3:
                    nova[i][j] = 1
            else:
                if p == 2 or p == 3:
                    nova[i][j] = 1
    generacia = nova
    ktora += 1

    okno.title('Hra Život - generácia #' + str(ktora))
    vykresli_aktualny_stav()


# funkcie súvisiace s grafickým výstupom
def vytvor_siet_stvorcekov():
    s = []
    for i in range(n):
        s.append([0] * n)
        for j in range(n):
            # výpočet súradníc aktuálneho štvorca siete
            x, y = d * j + x0, d * i + y0
            s[i][j] = platno.create_rectangle(x, y, x + d, y + d, fill='white', outline='gray')
    return s


def vykresli_aktualny_stav():
    for i in range(n):
        for j in range(n):
            x, y = d * j + x0, d * i + y0
            # pre bunku s hodnotou 0 bude výplň biela, pre hodnotu 1 zelená
            farba = ['white', 'green'][generacia[i][j]]
            # zmena farby výplne štvorčeka vzhľadom na aktuálny stav v generácii
            platno.itemconfig(stvorceky[i][j], fill=farba)


def klik(event):
    s, r = (event.x - x0) // d, (event.y - y0) // d
    if 0 <= r < len(generacia) and 0 <= s < len(generacia[r]):
        if generacia[r][s] == 0:
            generacia[r][s] = 1
            platno.itemconfig(stvorceky[r][s], fill='green')
        else:
            generacia[r][s] = 0
            platno.itemconfig(stvorceky[r][s], fill='white')


# globálne premenné
n = 50      # rozmer siete
ktora = 0   # počítadlo generácií
d, x0, y0 = 10, 5, 5  # veľkosť štvorcového políčka a  ľavý horný roh siete

# vytvorenie GUI
okno = tkinter.Tk()
okno.title('Hra Život - generácia #0')

platno = tkinter.Canvas(okno, width=n * d + 10, height=n * d + 10, bg='lightgreen')
platno.bind('<Button-1>', klik)
platno.pack()

tlacidlo = tkinter.Button(okno, text='dalsia generacia', command=dalsia_generacia)
tlacidlo.pack()

stvorceky = vytvor_siet_stvorcekov()
generacia = prazdna()
vykresli_aktualny_stav()

# spustenie aplikácie
okno.mainloop()
